<?php

namespace Tests\Long;

use App\Rules\ValidVehicleRegistrationNumber;
use App\Rules\VehicleExistsByIdentifier;
use Database\Seeders\Global\CountrySeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;
use Tests\UserForTenant;

/**
 * @group long
 */
class RuleTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testValidVehicleRegistrationNumber()
    {
        $this->seed(CountrySeeder::class);
        $this->assertTrue((new ValidVehicleRegistrationNumber(true))->passes('reg', 'HELLO WORLD'));
        $this->assertFalse((new ValidVehicleRegistrationNumber(false))->passes('reg', 'HELLO WORLD'));

        $this->assertTrue((new ValidVehicleRegistrationNumber(false))->passes('reg', 'AB10DEL'));
        $this->assertTrue((new ValidVehicleRegistrationNumber(false))->passes('reg', 'ZZ44CES'));
        $this->assertTrue((new ValidVehicleRegistrationNumber(false))->passes('reg', 'YY91XYX'));
        $this->assertFalse((new ValidVehicleRegistrationNumber(false))->passes('reg', '1A2B'));
        $this->assertFalse((new ValidVehicleRegistrationNumber(false))->passes('reg', '1AA3VVV'));
        $this->assertFalse((new ValidVehicleRegistrationNumber(false))->passes('reg', '1AAVV3'));
        $this->assertStringContainsString('is not valid', (new ValidVehicleRegistrationNumber())->message());
        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', null));
        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', ''));
        $this->assertTrue((new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', 'AB59 DAC'));
        $this->assertFalse(
            (new ValidVehicleRegistrationNumber(false, true))->passes('registration_number', 'INVALID123')
        );
        $this->assertTrue(
            (new ValidVehicleRegistrationNumber(true, true))->passes('registration_number', 'HELLO WORLD')
        );
    }

    public function testVehicleExistsByIdentifier()
    {
        Vehicle::factory()->create([
            'registration_number' => 'AB10DEL',
            'vin' => 'ABC123',
        ]);

        $this->assertTrue((new VehicleExistsByIdentifier())->passes('slug', 'AB10 DEL'));
        $this->assertTrue((new VehicleExistsByIdentifier())->passes('slug', 'AB10DEL'));
        $this->assertTrue((new VehicleExistsByIdentifier())->passes('slug', 'ABC123'));
        $this->assertFalse((new VehicleExistsByIdentifier())->passes('slug', 'lorem-ipsum'));
        $this->assertStringContainsString('not found', (new VehicleExistsByIdentifier())->message());
    }
}
