<?php

namespace App\Http\Resources;

use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;

trait ResourceMediaEntries
{
    public function getMediaEntries(): array
    {
        return [
            'media' => $this->resource->mediaUses->pluck('media_id'),
            'media_uses' => $this->resource->mediaUses
                ->map(fn(MediaUse $mediaUse) => new MediaEntryResource($mediaUse)),
            'primary_media' => $this->resource->mediaUses->where('primary', 1)->first()?->media_id,
        ];
    }
}
