<?php

namespace App\Listeners;

use App\Facades\Settings;
use App\Services\AutoTraderHub;
use App\Traits\EnsuresVehicleAttribute;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Events\SettingUpdated;

class CreateVehicleIsPreRegAttribute
{
    use EnsuresVehicleAttribute;

    public function __construct(private readonly AutoTraderHub $autoTraderHub)
    {
        //
    }

    public function handle(SettingUpdated $event)
    {
        if ($event->setting->config_key === 'vehicles-pre-reg-condition-enabled' && $event->setting->value) {
            $this->getVehicleAttribute(
                'Pre-Reg vehicle',
                'boolean',
                'is-pre-reg',
            );
        }
    }
}
