<?php

namespace App\Models;

use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

/**
 * @property int $id
 * @property int $ev_db_id
 * @property string $vehicle_type
 * @property int $make_id
 * @property int $model_id
 * @property string $variant
 * @property Carbon $date_from
 * @property Carbon $date_to
 * @property Collection|EVDataAttribute[] $evDataAttributes
 */
class EVData extends Model
{
    use CentralConnection;

    protected $table = 'ev_data';

    protected $fillable = [
        'ev_db_id',
        'vehicle_type',
        'make_id',
        'model_id',
        'variant',
        'date_from',
        'date_to',
    ];

    public function make(): BelongsTo
    {
        return $this->belongsTo(VehicleMake::class);
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(VehicleModel::class);
    }

    public function evDataAttributes(): HasMany
    {
        return $this->hasMany(EVDataAttribute::class, 'ev_data_id');
    }
}
