<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;

class MatomoConfiguredInSettings extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'matomo_configured_settings';
    }

    public function handle(): bool
    {
        $matomo_id = tenant('matomo_site_id');
        if (empty($matomo_id)) {
            $this->failure_reason = __('go-live.errors.matomo-id-missing');
            return false;
        }
        return true;
    }
}
