<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Mtc\MercuryDataModels\TransmissionType;

class TransmissionController extends Controller
{
    /**
     * Display a listing of transmissions
     *
     * @return LengthAwarePaginator
     */
    public function index()
    {
        return TransmissionType::query()->orderBy('name')->paginate();
    }

    /**
     * Display the specified transmission.
     *
     * @param  TransmissionType $transmission
     * @return TransmissionType
     */
    public function show(TransmissionType $transmission)
    {
        return $transmission;
    }
}
