<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Shortcode;

class ShortcodeList extends JsonResource
{
    public static $wrap = '';

    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn(Shortcode $vehicle) => $this->mapShortcode($vehicle));
        } else {
            $this->resource = $this->resource
                ->map(fn(Shortcode $vehicle) => $this->mapShortcode($vehicle));
        }
        return parent::toArray($request);
    }

    protected function mapShortcode(Shortcode $shortcode)
    {
        return [
            'id' => $shortcode->id,
            'title' => $shortcode->name,
            'description' => '{{' . $shortcode->code . '}}',
        ];
    }
}
