<?php

namespace App\Modules\Lookup\Contracts;

use Illuminate\Support\Collection;

class VehicleLookupData
{
    public function __construct(
        public readonly ?string $make = null,
        public readonly ?string $model = null,
        public readonly ?string $generation = null,
        public readonly ?string $derivative = null,
        public readonly ?string $trim = null,
        public readonly ?string $body_type = null,
        public readonly ?string $vehicle_type = null,
        public readonly ?string $fuel_type = null,
        public readonly ?string $transmission = null,
        public readonly ?string $registration_date = null,
        public readonly ?string $drivetrain = null,
        public readonly ?string $seats = null,
        public readonly ?string $doors = null,
        public readonly ?string $drive_type = null,
        public readonly ?string $engine_capacity_cc = null,
        public readonly ?string $vin = null,
        public readonly ?int $previous_owner_count = null,
        public readonly ?Collection $features = null,
        public readonly ?Collection $standard_equipment = null,
        public readonly ?Collection $optional_equipment = null,
        public readonly ?Collection $technical_data = null,
    ) {
        //
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
