<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleLabelSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Vehicle labels',
                'config_key' => 'vehicle-labels-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'standard',
                'description' => 'Enable vehicle labels'
            ],
        ];
    }
}
