<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeaseDiscount;

class ImportDiscountsJob extends BaseImportJob
{
    public function importItem(array $item)
    {
        KeyloopLeaseDiscount::query()->updateOrCreate([
            'external_variant_id' => $item['external_variant_id'],
            'make_id' => $item['make_id'],
            'model_id' => $item['model_id'],
            'discount_type' => $item['discount_type'],
        ], [
            'discount_amount' => $item['discount_amount'],
            'was_recently_synced' => true,
        ]);
    }
}
