<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\AutoTraderCSVExportJob;
use App\Jobs\SyncVehicleAutoTraderIdAfterCsvExport;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class AutoTraderCSVExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Queue::fake();
        Storage::fake('auto-trader-export');
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-auto-trader-file-name', 'foo.csv');

        (new AutoTraderCSVExportJob())->handle();

        Storage::disk('auto-trader-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'auto-trader-sales')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
        Queue::assertPushed(SyncVehicleAutoTraderIdAfterCsvExport::class);
    }
}
