<?php

namespace App\Contracts;

use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

interface AIContentDriver
{
    /**
     * Get AI generated description for a vehicle/vehicle offer
     *
     * @param Vehicle|VehicleOffer $model
     * @return string
     */
    public function getDescription(Vehicle|VehicleOffer $model): string;

    /**
     * Determine if AI generation should occur on vehicle import.
     *
     * @return bool
     */
    public function canGenerateDescriptionOnImport(): bool;
}
