<?php

namespace App\Http\Resources;

use Illuminate\Support\Facades\App;
use Mtc\Reports\Http\Resources\ReportListResource as BaseReportResourceList;
use Mtc\Reports\Contracts\ReportModel;

class ReportListResource extends BaseReportResourceList
{
    public static $wrap = '';
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'reports' => $this->resource->through(fn (ReportModel $report) => [
                'id' => $report->id,
                'name' => $report->name,
                'metaItems' => [
                    App::make(config('reports.types.' . $report->type))->name(),
                    $report->active ? 'Active' : 'Disabled',
                ]
            ]),
            'types' => collect(config('reports.types', []))
                ->map(fn ($type, $key) => [
                    'id' => $key,
                    'name' => App::make($type)->name(),
                ])->values(),
        ];
    }
}
