<?php

namespace App\Master\Http\Resources;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use JsonSerializable;
use Mtc\MercuryDataModels\Permission;
use Mtc\MercuryDataModels\Tenant;

class RoleViewResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'role' => [
                'id' => $this->resource->id,
                'name' => $this->resource->name,
                'permissions' => $this->resource->permissions->pluck('name'),
                'tenant' => $this->resource->tenant ?? 'all',
            ],
            'permissions' => Permission::query()->orderBy('name')->get(),
            'tenants' => Tenant::query()->orderBy('name')->select(['id', 'name'])->get()
                ->prepend([
                    'id' => 'all',
                    'name' => 'Global (all)',
                ]),
        ];
    }
}
