<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoColourMapSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Filter',
            'group' => 'General',
            'name' => 'Automatically map colours after stock sync',
            'config_key' => 'filter-auto-map-colours',
            'type' => 'boolean',
            'value' => false,
            'min_tier' => 'standard',
            'description' => 'If enabled the colour mapping will attempt automated mapping by selecting the colour '
                . 'that is included in the vehicle colour',
            'order' => 3,
        ]);

    }
}
