<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SeoSitemapSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->settings())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function settings(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'Include SRP pages',
                'config_key' => 'seo-sitemap-include-srp',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Include Search Results Pages (SRP) in the sitemap',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'SRP URL type',
                'config_key' => 'seo-sitemap-srp-type',
                'type' => 'string',
                'value' => 'fixed-path',
                'choices' => [
                    ['value' => 'fixed-path', 'name' => 'Fixed Path'],
                    ['value' => 'path-plus-franchise', 'name' => 'Path + Franchise'],
                    ['value' => 'condition-based-url', 'name' => 'Condition (new/used) and type Based URL'],
                ],
                'description' => 'How SRP URLs should be generated in the sitemap',
                'order' => 2,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'SRP Path',
                'config_key' => 'seo-sitemap-srp-path',
                'type' => 'string',
                'value' => '/used-cars',
                'description' => 'The base path for SRP pages (e.g., /used-cars)',
                'order' => 3,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'Include SRP make pages',
                'config_key' => 'seo-sitemap-include-srp-makes',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Include make-specific SRP pages in the sitemap (e.g., /used-cars/ford)',
                'order' => 4,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'Include SRP model pages',
                'config_key' => 'seo-sitemap-include-srp-models',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Include model-specific SRP pages in the sitemap (e.g., /used-cars/ford/focus)',
                'order' => 5,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'New cars called stock',
                'config_key' => 'seo-sitemap-new-cars-called-stock',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When new car stock is located in /new-stock instead of /new-cars URLs',
                'order' => 6,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'Include FPA pages',
                'config_key' => 'seo-sitemap-include-fpa',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Include Full Page Adverts (FPA) / Vehicle Detail Pages in the sitemap',
                'order' => 7,
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Sitemap',
                'name' => 'Fixed URLs',
                'config_key' => 'seo-sitemap-fixed-urls',
                'type' => 'text',
                'value' => '',
                'description' => 'Additional fixed URLs to include in the sitemap (one URL per line, no domain or leading slash, only path to section)',
                'order' => 8,
            ],
        ];
    }
}
