<?php

namespace App\Http\Resources;

use App\TierHelper;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use JsonSerializable;

class SiteUserListResource extends JsonResource
{
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'limit' => TierHelper::userLimit(tenant('tier')),
            'users' => $this->resource->getCollection()
                ->map(fn($user) => [
                    'id' => $user->id,
                    'name' => $user->name,
                    'taggable' => Str::slug($user->name),
                    'metaItems' => [
                        'role' => $user->pivot->role ?? '',
                    ],
                    'email' => $user->email,
                    'image' => [
                        'src' => $user->profile_photo_url,
                        'alt' => $user->name,
                    ],
                    'last_login_at' => $user->last_login_at,
                ]),
            'current_page' => $this->resource->currentPage(),
            'last_page' => $this->resource->lastPage(),
            'per_page' => $this->resource->perPage(),
            'total' => $this->resource->total(),
        ];
    }
}
