<?php

namespace App\Modules\VehicleTrims\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

class VehicleTrimView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->data = $this->getDataValues();
        return parent::toArray($request);
    }

    private function getDataValues()
    {
        $data = $this->resource->data ?? [];

        $data['options']['make_ids'] = VehicleMake::query()
            ->orderBy('name')
            ->get()
            ->map(function ($option) {
                return [
                    'id' => (int) $option->id,
                    'name' => $option->name
                ];
            })->toArray();

        $data['options']['model_ids'] = VehicleModel::query()
            ->orderBy('name')
            ->get()
            ->map(function ($option) {
                return [
                    'id' => (int) $option->id,
                    'name' => $option->name
                ];
            })->toArray();

        return $data;
    }
}
