<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoGrabSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'AutoGrab',
                'name' => 'Enabled',
                'config_key' => 'stock-autograb-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enables processing AutoGrab stock feed. Requires API authentication set up.',
            ],
        ];
    }
}
