<?php

namespace App\Console\Commands;

use App\Mail\NewVehicleMakesModelsMail;
use App\Master\Services\AutoTraderTaxonomyService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Mtc\VehicleLookup\Drivers\CAP;

class CapRemoveModels extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cap:remove-models';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove Cap Models';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $count = VehicleModel::query()
            ->whereNull('autotrader_id')
            ->where(function ($query) {
                $query->whereNotNull('cap_id')
                    ->orWhereNotNull('lcv_cap_id');
            })
            ->delete();

        $this->info($count . ' removed');


        return 0;
    }
}
