<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkupenetVideoStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Synchronize video',
                'config_key' => 'stock-skupenet-sync-video',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'order' => 6,
                'description' => 'Update video of the vehicle from Skupenet'
            ],
        ];
    }
}
