<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CallDripSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'CallDrip',
                'name' => 'Enabled',
                'config_key' => 'chat-calldrip-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://app.calldrip.eu/" target="_blank">CallDrip</a> integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'CallDrip',
                'name' => 'Client Account Key',
                'config_key' => 'chat-calldrip-key',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'description' => 'CallDrip integration account key.',
                'validation_rules' => [
                    "required_if:values.chat-calldrip-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'CallDrip',
                'name' => 'Client Account ID',
                'config_key' => 'chat-calldrip-id',
                'type' => 'string',
                'value' => '',
                'order' => 2,
                'description' => 'CallDrip integration account id.',
                'validation_rules' => [
                    "required_if:values.chat-calldrip-enabled,true"
                ]
            ],
        ];
    }
}
