<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SalesforceStockExportSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Export Stock to Salesforce',
                'config_key' => 'sales-force-stock-export-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Send Autonomy site vehicle URL to SalesForce',
                'order' => 0,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Username',
                'config_key' => 'sales-force-stock-export-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-force-stock-export-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Password',
                'config_key' => 'sales-force-stock-export-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-force-stock-export-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Client ID',
                'config_key' => 'sales-force-stock-export-client-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-force-stock-export-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Salesforce',
                'name' => 'Client Secret',
                'config_key' => 'sales-force-stock-export-client-secret',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-force-stock-export-enabled,true"
                ],
            ],
        ];
    }
}
