<?php

namespace Tests\Tenant;

use App\Jobs\ChannelFeedExportJob;
use Database\Seeders\Tenant\ChannelFeedExportSeeder;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class ChannelFeedExportTest extends TenantTestCase
{
    public function testExportJobCreatesHistoryRecord()
    {
        Storage::fake('file-storage');
        $this->seed(ChannelFeedExportSeeder::class);
        Vehicle::factory(5)->create();

        (new ChannelFeedExportJob())->handle();

        // Check that history record was created (success or failure)
        $logged = SalesChannelHistory::query()
            ->where('channel', 'channel-feed')
            ->exists();
        $this->assertTrue($logged);
    }

    public function testExportJobWithVehicles()
    {
        Storage::fake('file-storage');
        $this->seed(ChannelFeedExportSeeder::class);
        Vehicle::factory(10)->create();

        (new ChannelFeedExportJob())->handle();

        // Verify job completed and logged result
        $history = SalesChannelHistory::query()
            ->where('channel', 'channel-feed')
            ->first();

        $this->assertNotNull($history);
    }
}
