<?php

namespace App\Backup;

use Illuminate\Support\Collection;
use Spatie\Backup\Tasks\Backup\BackupJobFactory as BaseBackupJobFactory;
use Spatie\Backup\Tasks\Backup\DbDumperFactory;

class BackupJobFactory extends BaseBackupJobFactory
{
    protected static function createDbDumpers(array $dbConnectionNames): Collection
    {
        return collect($dbConnectionNames)->mapWithKeys(
            fn (string $dbConnectionName) => [
                $dbConnectionName => DbDumperFactory::createFromConnection($dbConnectionName)
                    ->addExtraOption('-qC')
                    ->addExtraOption('--hex-blob')
                    ->addExtraOption('--single-transaction')
                    ->addExtraOption('--lock-tables')
                    ->addExtraOption('--force')
            ]
        );
    }
}
