<?php

namespace App\Http\Controllers;

use App\Http\Requests\RemoveDealStatus;
use App\Http\Requests\StoreDealStatus;
use App\Http\Requests\UpdateDealStatus;
use App\Http\Resources\DealStatusList;
use App\Http\Resources\DealStatusResource;
use Mtc\MercuryDataModels\DealBuilder\Status;

class DealStatusController extends Controller
{
    public function index(): DealStatusList
    {
        return new DealStatusList(Status::query()->latest()->paginate());
    }

    public function store(StoreDealStatus $request): DealStatusResource
    {
        return new DealStatusResource(Status::query()
            ->create(array_merge(['editable' => true ], $request->validated())));
    }

    public function show(Status $dealStatus): DealStatusResource
    {
        return new DealStatusResource($dealStatus);
    }

    public function update(UpdateDealStatus $request, Status $dealStatus): DealStatusResource
    {
        $dealStatus->update($request->validated());
        return new DealStatusResource($dealStatus);
    }

    public function destroy(RemoveDealStatus $request, Status $dealStatus): DealStatusList
    {
        $dealStatus->delete();
        return $this->index();
    }
}
