<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class RemoveDealStatus extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if (!$this->deal_status?->editable) {
                $validator->errors()->add('status', __('validation.item_not_removable'));
            }

            $in_use_count = $this->deal_status?->deals()->count();
            if ($in_use_count) {
                $validator->errors()->add('status', __('validation.deals.status_in_use', ['count' => $in_use_count]));
            }
        });
    }
}
