<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateDealAddon extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'active' => 'present',
            'description' => 'nullable',
            'price' => [
                'nullable',
                'numeric',
            ],
            'allow_roll_into_monthly' => [
                'nullable',
                'boolean',
            ],
            'conditions' => [
                'array',
            ],
            'conditions.*.field' => [
                'required',
            ],
            'conditions.*.condition' => [
                'required',
            ],
        ];
    }
}
