<?php

namespace App\Http\Resources;

use Mtc\MercuryDataModels\Contracts\ModelWithUrlPath;
use Mtc\MercuryDataModels\SeoData;

trait SeoDataForModel
{
    private function getSeoData(ModelWithUrlPath $model): array
    {
        $seoData = SeoData::query()->where('path', $model->urlPath())->first();
        if ($seoData) {
            return $seoData->only([
                'title',
                'description',
                'json_schema'
            ]);
        }

        return [
            'title' => '',
            'description' => '',
            'json_schema' => '',
        ];
    }
}
