<?php

namespace App\Http\Resources\Traits;

use Mtc\MercuryDataModels\DealBuilder\Deal;

trait BuildsDealTitle
{
    protected function buildDealTitle(Deal $deal): string
    {
        $customerName = trim(($deal->first_name ?? '') . ' ' . ($deal->last_name ?? ''));
        $vehicleInfo = collect([
            $deal->vehicle?->make?->name,
            $deal->vehicle?->model?->name,
            $deal->vehicle?->registration_number,
        ])->filter()->implode(' ');

        $title = collect([$customerName, $vehicleInfo])->filter()->implode(', ');

        return $title ?: $deal->reference;
    }
}
