<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Features\VehicleFeature;
use Mtc\MercuryDataModels\FilterFeature;
use Mtc\MercuryDataModels\VehicleStandardEquipment;

class AssignFilterFeatures implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly ?FilterFeature $feature = null)
    {
        $this->onQueue('sync');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if ($this->feature) {
            $this->singleFeature($this->feature, true);
        } else {
            $this->allFeatures();
        }
    }

    public function allFeatures(): void
    {
        FilterFeature::all()
            ->each(fn(FilterFeature $feature) => $this->singleFeature($feature));
    }

    public function singleFeature(FilterFeature $feature, bool $reset = false): void
    {
        if ($reset) {
            // Reset all entries with this as terms might have changed
            VehicleStandardEquipment::query()
                ->where('feature_id', $feature->id)
                ->update(['feature_id' => null]);
        }

        $query = VehicleStandardEquipment::query()
            ->distinct()
            ->select(['description']);

        foreach ($feature->terms as $term) {
            $query->orWhere('description', 'like', '%' . trim($term) . '%');
        }

        $query->update(['feature_id' => $feature->id]);
    }
}
