<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\DealBuilder\DealMessage;

class NewDealCustomerMessageJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly int $message_id)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $message = DealMessage::query()->findOrFail($this->message_id);
        if ($message->notification_sent_at) {
            return;
        }
    }
}
