<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ImportMapField extends Model
{
    use HasFactory;

    protected $fillable = [
        'map_id',
        'on_file',
        'on_model',
        'default_value',
        'is_list',
        'is_images',
        'list_separator',
        'data',
    ];

    protected $casts = [
        'is_list' => 'boolean',
        'is_images' => 'boolean',
        'data' => 'array',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function importMap(): BelongsTo
    {
        return $this->belongsTo(ImportMap::class, 'map_id');
    }
}
