<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\AaCarsExportJob;
use App\Jobs\CarSnipExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AaCars implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-aa-cars-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.aa_cars');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new AaCarsExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'aa-cars-dealer-id' => [
                'type' => 'text',
                'label' => 'Dealership name on AA Cars'
            ],
        ];
    }
}
