<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\CarsIrelandExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CarsIreland implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-cars-ireland-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.cars-ireland');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new CarsIrelandExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'cars-ireland-dealer-id' => [
                'type' => 'text',
                'label' => 'Dealership ID on CarsIreland'
            ],
        ];
    }
}
