<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\EasiChatExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class EasiChat implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-easichat-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.easichat');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new EasiChatExportJob());
        }
    }
}
