<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderHubUpdatedSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'AutoTrader Hub',
                'name' => 'Enabled',
                'config_key' => 'auto-trader-hub-enabled',
                'type' => 'boolean',
                'value' => false,
                'superadmin' => true,
                'description' => 'Use AutoTrader Hub to sync stock (Automatically creates a site within AutoTrader Hub when enabled).',
                'order' => 0,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'AutoTrader Hub',
                'name' => 'AutoTrader Hub access token',
                'config_key' => 'auto-trader-hub-token',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
                'description' => 'Token is used for connecting to AT Hub and identify site on it.',
                'order' => 99,
            ],
        ];
    }
}
