<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealBuilderSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Deal Builder',
                'name' => 'Allow multiple part-exchange vehicles',
                'config_key' => 'deal-builder-allow-multiple-part-exchange',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When disabled, customers can only add one part-exchange vehicle per deal',
                'order' => 1,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Deal Builder',
                'name' => 'Allow deposit payment',
                'config_key' => 'deal-builder-allow-deposit-payment',
                'type' => 'boolean',
                'value' => true,
                'description' => 'Allow customers to pay a deposit to secure their deal',
                'order' => 2,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Deal Builder',
                'name' => 'Allow full payment',
                'config_key' => 'deal-builder-allow-full-payment',
                'type' => 'boolean',
                'value' => true,
                'description' => 'Allow customers to pay the full amount upfront',
                'order' => 3,
            ],
        ];
    }
}
