<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\DealBuilder\Status;

class DealBuilderStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($item) => Status::query()->updateOrCreate(['name' => $item['name']], $item));
    }

    private function data(): array
    {
        return [
            [
                'name' => 'Received',
                'editable' => false,
                'is_initial' => true,
                'is_final' => false,
            ],
            [
                'name' => 'In progress',
                'editable' => true,
                'is_initial' => false,
                'is_final' => false,
            ],
            [
                'name' => 'Need more information',
                'editable' => true,
                'is_initial' => false,
                'is_final' => false,
            ],
            [
                'name' => 'Completed',
                'editable' => true,
                'is_initial' => false,
                'is_final' => true,
            ],
            [
                'name' => 'Cancelled',
                'editable' => true,
                'is_initial' => false,
                'is_final' => true,
            ],
        ];
    }
}
