<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerWebLmsTestSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Test LMS Username',
                'config_key' => 'test_dealerweblms-lms-username',
                'type' => 'string',
                'value' => '',
                'description' => 'The test username for Dealer Web LMS integration. Used in non-production environments.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Test DealerID/DealerNo',
                'config_key' => 'test_dealerweblms-dealerid',
                'type' => 'string',
                'value' => '',
                'description' => 'The test Dealer ID or Dealer Number used for integration. Used in non-production environments.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Test Password',
                'config_key' => 'test_dealerweblms-password',
                'type' => 'string',
                'value' => '',
                'description' => 'The test password for Dealer Web LMS integration. Used in non-production environments.'
            ],
        ];
    }
}
