<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ReservationEmailRecipientSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Stripe',
                'name' => 'Confirmation recipient email address(es)',
                'config_key' => 'reservations-admin-team-emails',
                'type' => 'string',
                'value' => '',
                'description' => 'Emails, comma seperated',
                'order' => 41,
            ],
        ];
    }
}
