@php
    $layerWhiteColour = '#fff';
    $layerBodyColour = '#f4f4f4';
    $innerWrapperWidth = '700';
    $contentWrapperWidth = '600';
@endphp

    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>{{ config('app.name') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;
            background: {{ $layerBodyColour }};
            font-size: 16px;
            line-height: 24px;
            color: {{ $colours['app-text-colour'] }};
        }

        p {
            margin: 0 0 24px;
        }

        a {
            color: {{ $colours['app-primary-colour'] }};
            text-decoration: underline;
        }

        .subjectTitle {
            font-size: 18px;
            letter-spacing: 2px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .smallText {
            font-size: 12px;
            line-height: 16px;
        }

        @media only screen and (max-width: 600px) {
            .responsiveWrapper {
                width: 100% !important;
            }
        }
    </style>
</head>
<body>

<table width="100%" cellpadding="0" cellpadding="0" role="presentation">
    <tr>
        <td>
            <table cellpadding="0"
                   cellspacing="0"
                   border="0"
                   align="center"
                   bgcolor="{{ $layerWhiteColour }}"
                   width="{{ $innerWrapperWidth }}"
                   class="responsiveWrapper"
            >
                <tr>
                    <td>
                        <table width="100%"
                               align="center"
                               border="0"
                               cellspacing="0"
                               cellpadding="0"
                               style="margin:0 auto;"
                        >

                            <tr>
                                <td height="20"></td>
                            </tr>

                            <tr>
                                <td align="center">
                                    <a href="{{ $site_url ?? config('app.url') }}">
                                        <img src="{{ $site_logo['url'] }}" alt="{{ $site_name }}" style="display:block;border:0;" width="160">
                                    </a>
                                </td>
                            </tr>

                            @if (!empty($subject))
                                <tr>
                                    <td height="10"></td>
                                </tr>

                                <tr>
                                    <td align="center">
                                        <h1 class="subjectTitle">
                                            {{ $subject }}
                                        </h1>
                                    </td>
                                </tr>
                            @endif

                            <tr>
                                <td height="10"></td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <tr>
                    <td colspan="2" height="4" bgcolor="{{ $colours['app-primary-colour'] }}"></td>
                </tr>

                <tr>
                    <td colspan="2" height="20"></td>
                </tr>

                <tr>
                    <td colspan="2">
                        <table cellpadding="0"
                               cellspacing="0"
                               border="0"
                               align="center"
                               width="100%"
                        >
                            <tr>
                                <td>
                                    <table width="{{ $contentWrapperWidth }}"
                                           align="center"
                                           border="0"
                                           cellspacing="0"
                                           cellpadding="0"
                                           style="margin:0 auto;"
                                    >
                                        <tr>
                                            <td>
                                                @yield('content')
                                                {{ $subcopy ?? '' }}
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>

                        </table>
                    </td>
                </tr>



            </table>
        </td>
    </tr>

    <tr>
        <td colspan="2" height="20"></td>
    </tr>


    <tr>
        <td colspan="2">
            <table cellpadding="0"
                   cellspacing="0"
                   border="0"
                   align="center"
                   width="100%"
            >
                <tr>
                    <td>
                        <table width="{{ $contentWrapperWidth }}"
                               align="center"
                               border="0"
                               cellspacing="0"
                               cellpadding="0"
                               style="margin:0 auto;"
                        >
                            @yield('footer')

                            <tr>
                                <td align="center">

                                    <p>Visit us online: <a href="{{ config('app.url') }}" target="_blank">{{ $site_name }}</a></p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

            </table>
        </td>
    </tr>
</table>


</body>
</html>
