<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Tests\TestCase;
use Tests\UserForTenant;

class ChecklistTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testChecklistPage()
    {

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.settings.checklist'));

        $response->assertStatus(200);
        $this->assertCount(3, $response->json());
        $this->assertArrayHasKey('name', $response->json('0'));
        $this->assertArrayHasKey('passes', $response->json('0'));
        $this->assertArrayHasKey('check_url', $response->json('0'));
    }

    public function testDomainChecklist()
    {
        $domain = tenant()->domains()->create([
            'primary' => 1,
            'domain' => 'localhost'
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.checklists.domain', $domain));

        $response->assertStatus(200);
        $this->assertTrue($response->json('status'));

        $domain->update([
            'domain' => 'google.com',
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.checklists.domain', $domain));
        $this->assertFalse($response->json('status'));
    }

    public function testMailChecklist()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.checklists.mail'));

        $response->assertStatus(200);
        $this->assertFalse($response->json('status'));
    }
}
