<?php

namespace Tests\Feature;

use App\Console\Commands\ClearOldReportingStats;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\ReportingStat;
use Tests\TenantTestCase;
use Tests\TestCase;

class ClearReportingStatsTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testClearStats()
    {
        Config::set('automotive.dashboard-history-length', 30);

        // 10 records to clear
        ReportingStat::factory(10)->create([
            'date' => Carbon::now()->subDays(100),
        ]);

        // 5 to keep
        ReportingStat::factory(5)->create([
            'date' => Carbon::now()->subDays(2),
        ]);

        $response = $this->artisan(ClearOldReportingStats::class);
        $response->run();

        $response->assertExitCode(0);
        $this->assertEquals(5, ReportingStat::query()->count());
    }
}
