<?php

namespace Tests\Feature;

use App\Models\ContentSync;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class ContentSyncControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        ContentSync::factory(5)->create();
        $response = $this->actingAs($this->getUser())
            ->getJson(route('content-sync.index'));

        $response->assertStatus(200);

        $this->assertIsArray($response->json());
        $this->assertEquals(5, $response->json('total'));
    }

    public function testShow()
    {
        $sync = ContentSync::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->getJson(route('content-sync.show', $sync));

        $response->assertStatus(200);
        $this->assertArrayHasKey('tenant_id', $response->json());
        $this->assertArrayHasKey('user_id', $response->json());
    }
}
