<?php

namespace Tests\Feature;

use App\Traits\EnsuresVehicleAttribute;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\VehicleAttribute;
use Tests\TenantTestCase;
use Tests\TestCase;
use Tests\UserForTenant;

class VehicleAttributeTraitTest extends TenantTestCase
{
    use EnsuresVehicleAttribute;

    public function testEmptyAttributes()
    {
        $this->assertEmpty(VehicleAttribute::all());
    }

    public function testAttribute()
    {
        $this->getVehicleAttribute('example_attribute', 'boolean');

        $this->assertCount(1, VehicleAttribute::all());
        $this->assertEquals('example_attribute', VehicleAttribute::first()->name);
    }
}
