<?php

namespace Tests;

use Database\Seeders\Global\GlobalRoleSeed;
use Mtc\MercuryDataModels\User;

trait UserForTenant
{
    protected User $user;

    protected function getUser($role = 'mtc'): User
    {
        if (empty($this->user)) {
            $this->seed(GlobalRoleSeed::class);
            $this->user = User::factory()->create();

            if (!empty(tenant('id'))) {
                $this->user->tenants()->attach(tenant('id'), ['role' => $role]);
            }

            if ($role === 'mtc') {
                $this->user->assignRole($role);
            }

        }
        return $this->user;
    }
}
