<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoloadItSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Autoload It',
                'name' => 'Enabled',
                'config_key' => 'image-sync-autoloadit-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'order' => 20,
                'description' => 'Vehicle images provided via Autoload It feed'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Autoload It',
                'name' => 'Feed URL path',
                'config_key' => 'image-sync-autoloadit-endpoint',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'order' => 22,
                'description' => 'Path to the feed after domain e.g. /export/id/...'
            ],
        ];
    }
}
