@extends('crm::emails.layout', [
    'subject' => $enquiry->subject ?? 'We have received your service booking',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'site_url' => $site_url,
    'colours' => $colours,
])

@section('content')

    @if(!empty($booking->subject))
        <h1>{{ $booking->subject }}</h1>
    @endif
    @if(!empty($booking->intro))
        <p>{{ $booking->intro }}</p>
    @endif


    <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0"
           style="margin:0 auto;"
    >
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Registration Number</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->registration_number  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Mileage</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->mileage  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Email</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->email  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Phone</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->phone_number  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>First Name</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->first_name  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Last Name</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->last_name  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Booking Time</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->booking_time  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Packages</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {!! $booking->packages->pluck('name')->implode('<br/>')  !!}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Location</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->location?->name  }}
            </td>
        </tr>
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Vehicle Details</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {!!
                    collect($booking->vehicle_data ?? [])
                    ->filter()
                    ->map(fn($value, $key) => ucfirst(str_replace('_', ' ', $key) . ': ' . $value ))
                    ->implode('<br/>')
                !!}
            </td>
        </tr>
        @if (!empty($booking->data))
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Additional Details</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {!!
                    collect($booking->data ?? [])
                    ->filter()
                    ->map(fn($value, $key) => ucfirst(str_replace('_', ' ', $key) . ': ' . $value ))
                    ->implode('<br/>')
                !!}
            </td>
        </tr>
        @endif
        <tr>
            <td width="32%" valign="top" style="border-bottom:1px solid #d4d4d4;">
                <strong>Notes</strong>
            </td>

            <td width="58%" valign="middle"
                style="border-bottom:1px solid #d4d4d4;">
                {{ $booking->notes  }}
            </td>
        </tr>
    </table>

    <p>
        <a href="{{ config('app.url') }}/service-booking/bookings/view/{{ $booking->id }}" target="_blank">View booking in CRM</a>
    </p>
@endsection

@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">
            {!! $footer !!}
        </td>
    </tr>
@endsection
