<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class VehicleUuidSlugSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $setting = Setting::query()
            ->where('config_key', 'automotive-vehicles-url_building_format')
            ->firstOrFail();

        $choices = $setting->choices;

        $choices[] = [
            'value' => 'uuid',
            'name' => 'UUID converted to URL'
        ];

        $setting->choices = $choices;
        $setting->save();
    }
}
